x1 = linspace(-5, 5, 1000);
x2 = linspace(0.05, 5, 1000);
x3 = linspace(-2, 2, 1000);

y1 = x1.^2;
y2 = log(x2);
y3 = exp(x3);

figure;
plot(x1,y1,'b-','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = x^2');

figure;
plot(x2,y2,'r--','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = log(x)');

figure; plot(x3,y3,'g:','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = e^x');

x = linspace(0.05, 5, 1000);
figure('Name','Razem');
plot(x, x.^2, 'b-', x, log(x), 'r--', x, exp(x), 'g:', 'LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = x^2, y = log(x), y = e^x (na jednym wykresie)');
legend('x^2','log(x)','e^x','Location','northwest');

figure('Name','Subplot');
subplot(1,3,1);
plot(x1,y1,'b-','LineWidth',1.5); grid on;
title('y = x^2');
xlabel('x');
ylabel('y');

subplot(1,3,2);
plot(x2,y2,'r--','LineWidth',1.5); grid on;
title('y = log(x)');
xlabel('x');
ylabel('y');

subplot(1,3,3);
plot(x3,y3,'g:','LineWidth',1.5);
grid on;
title('y = e^x');
xlabel('x');
ylabel('y');

xv = 0:0.1:10;
yv = 0:0.1:10;
[X,Y] = meshgrid(xv, yv);

Z = sin(X) .* X .* Y;

figure('Name','Zadanie 2');

subplot(2,2,1);
mesh(X,Y,Z);
grid on;
title('mesh');
xlabel('x');
ylabel('y');
zlabel('z');

subplot(2,2,2);
meshc(X,Y,Z);
grid on;
title('meshc');
xlabel('x');
ylabel('y');
zlabel('z');

subplot(2,2,3);
surf(X,Y,Z);
grid on;
title('surf');
xlabel('x');
ylabel('y');
zlabel('z');

subplot(2,2,4);
surfc(X,Y,Z);
grid on;
title('surfc');
xlabel('x');
ylabel('y');
zlabel('z');

figure('Name','Contour');
[x,y] = meshgrid(-5:0.1:5, -5:0.1:5);
z = x.^2 - y.^2;
contour(x,y,z,20);
grid on;
colorbar;
title('Poziomice');
xlabel('x');
ylabel('y');

figure('Name','fplot(tan)');
fplot(@tan, [-2*pi, 2*pi], 'LineWidth', 1.2);
grid on; ylim([-10 10]);
title('y = tan(x)');
xlabel('x');
ylabel('y');

figure('Name','histogram');
r = randn(1000,1);
histogram(r, 30);
grid on;
title('Histogram');
xlabel('wartość');
ylabel('liczność');

figure('Name','polarplot');
theta = 0:0.01:2*pi;
rho = sin(2*theta).*cos(2*theta);
polarplot(theta, rho, 'LineWidth', 1.5);
title('polarplot');
grid on;
